<?php
namespace Grav\Plugin;

use Composer\Autoload\ClassLoader;
use Grav\Common\Plugin;
use Grav\Plugin\PopularArticles\PopularArticles;

class PopularArticlesPlugin extends Plugin
{
    public static function getSubscribedEvents(): array
    {
        return [
            'onPluginsInitialized' => ['onPluginsInitialized', 0],
        ];
    }

    public function autoload(): ClassLoader
    {
        return require __DIR__ . '/vendor/autoload.php';
    }

    public function onPluginsInitialized(): void
    {
        if ($this->isAdmin()) {
            return;
        }

        // 加载配置并合并默认值
        $config = (array)$this->config->get('plugins.popular-articles', []);
        $defaults = [
            'enabled' => true,
            'blog_route' => '/',
            'articles_count' => 5
        ];
        $config = array_merge($defaults, $config);
        
        // 存储配置用于后续使用
        $this->grav['twig']->twig_vars['popular_articles_config'] = $config;
        
        // 启用必要的事件
        $this->enable([
            'onTwigTemplatePaths' => ['onTwigTemplatePaths', 0],
            'onTwigSiteVariables' => ['onTwigSiteVariables', 0]
        ]);
    }

    public function onTwigTemplatePaths()
    {
        $this->grav['twig']->twig_paths[] = __DIR__ . '/templates';
    }

    public function onTwigSiteVariables()
    {
        $twig = $this->grav['twig'];
    
        // 传递配置给 PopularArticles
        $config = $twig->twig_vars['popular_articles_config'] ?? [];
        $popularArticles = new PopularArticles($config);
        
        // 将实例暴露给 Twig
        $twig->twig_vars['popular_articles'] = $popularArticles;
    }
}